#include <hidef.h>      /* common defines and macros */
#include "derivative.h"      /* derivative-specific definitions */


//==============================================================================
//create reset vector at address 0xEFFE that will be used by bootloader
extern void near _Startup(void);
typedef void (*near tFunc)(void);
const tFunc rst_vec @0xEFFE = _Startup;

//==============================================================================
#pragma CODE_SEG NON_BANKED
interrupt void Unimplemented_ISR(void)
{
  asm BGND; //software breakpoint
}
#pragma CODE_SEG DEFAULT

//==============================================================================
#pragma CODE_SEG NON_BANKED
interrupt void PIT0_ISR(void)
{
  PORTA_PA0 = ~PORTA_PA0; //toggle LED on PORTA    
  
  PITTF = 0x01;           //clear interrupt flag
}

#pragma CODE_SEG DEFAULT
//==============================================================================


//==============================================================================
//This is an interurpt vector table located at 0x7F80 - 0x7FFF. 
//The interrupt vector base is set in main function to 0x7F.
//See the .prm file - the flash segment ROM_4000 must be cut of to area 0x4000-0x7F7F
//==============================================================================
typedef void (*near tIsrFunc)(void);
const tIsrFunc VectorTable[] @0x7F10 = 
{
  Unimplemented_ISR,    // Vector base + 0x10   Spurious interrupt
  Unimplemented_ISR,    // Vector base + 0x12   System Call Interrupt (SYS)
  Unimplemented_ISR,    // Vector base + 0x14   Reserved
  Unimplemented_ISR,    // Vector base + 0x16   Reserved
  Unimplemented_ISR,    // Vector base + 0x18   Reserved
  Unimplemented_ISR,    // Vector base + 0x1A   Reserved
  Unimplemented_ISR,    // Vector base + 0x1C   Reserved
  Unimplemented_ISR,    // Vector base + 0x1E   Reserved
  Unimplemented_ISR,    // Vector base + 0x20   Reserved
  Unimplemented_ISR,    // Vector base + 0x22   Reserved
  Unimplemented_ISR,    // Vector base + 0x24   Reserved
  Unimplemented_ISR,    // Vector base + 0x26   Reserved
  Unimplemented_ISR,    // Vector base + 0x28   Reserved
  Unimplemented_ISR,    // Vector base + 0x2A   Reserved
  Unimplemented_ISR,    // Vector base + 0x2C   Reserved
  Unimplemented_ISR,    // Vector base + 0x2E   Reserved
  Unimplemented_ISR,    // Vector base + 0x30   Reserved
  Unimplemented_ISR,    // Vector base + 0x32   Reserved
  Unimplemented_ISR,    // Vector base + 0x34   Reserved
  Unimplemented_ISR,    // Vector base + 0x36   Reserved
  Unimplemented_ISR,    // Vector base + 0x38   Reserved
  Unimplemented_ISR,    // Vector base + 0x3A   Reserved
  Unimplemented_ISR,    // Vector base + 0x3C   Reserved
  Unimplemented_ISR,    // Vector base + 0x3E   ATD0 Compare Interrupt
  Unimplemented_ISR,    // Vector base + 0x40   Reserved
  Unimplemented_ISR,    // Vector base + 0x42   Reserved
  Unimplemented_ISR,    // Vector base + 0x44   Reserved
  Unimplemented_ISR,    // Vector base + 0x46   Reserved
  Unimplemented_ISR,    // Vector base + 0x48   Reserved
  Unimplemented_ISR,    // Vector base + 0x4A   Reserved
  Unimplemented_ISR,    // Vector base + 0x4C   Reserved
  Unimplemented_ISR,    // Vector base + 0x4E   Reserved
  Unimplemented_ISR,    // Vector base + 0x50   Reserved
  Unimplemented_ISR,    // Vector base + 0x52   Reserved
  Unimplemented_ISR,    // Vector base + 0x54   Reserved
  Unimplemented_ISR,    // Vector base + 0x56   Reserved
  Unimplemented_ISR,    // Vector base + 0x58   Reserved
  Unimplemented_ISR,    // Vector base + 0x5A   Reserved
  Unimplemented_ISR,    // Vector base + 0x5C   Reserved
  Unimplemented_ISR,    // Vector base + 0x5E   Reserved
  Unimplemented_ISR,    // Vector base + 0x60   Reserved
  Unimplemented_ISR,    // Vector base + 0x62   Reserved
  Unimplemented_ISR,    // Vector base + 0x64   Reserved
  Unimplemented_ISR,    // Vector base + 0x66   Reserved
  Unimplemented_ISR,    // Vector base + 0x68   Reserved
  Unimplemented_ISR,    // Vector base + 0x6A   Reserved
  Unimplemented_ISR,    // Vector base + 0x6C   Reserved
  Unimplemented_ISR,    // Vector base + 0x6E   Reserved
  Unimplemented_ISR,    // Vector base + 0x70   Reserved
  Unimplemented_ISR,    // Vector base + 0x72   Reserved
  Unimplemented_ISR,    // Vector base + 0x74   Periodic interrupt timer channel 3
  Unimplemented_ISR,    // Vector base + 0x76   Periodic interrupt timer channel 2
  Unimplemented_ISR,    // Vector base + 0x78   Periodic interrupt timer channel 1
  PIT0_ISR,             // Vector base + 0x7A   Periodic interrupt timer channel 0
  Unimplemented_ISR,    // Vector base + 0x7C   High Temperature Interrupt (HTI)
  Unimplemented_ISR,    // Vector base + 0x7E   Autonomous periodical interrupt (API)
  Unimplemented_ISR,    // Vector base + 0x80   Low-voltage interrupt (LVI)
  Unimplemented_ISR,    // Vector base + 0x82   Reserved
  Unimplemented_ISR,    // Vector base + 0x84   Reserved
  Unimplemented_ISR,    // Vector base + 0x86   Reserved
  Unimplemented_ISR,    // Vector base + 0x88   Reserved
  Unimplemented_ISR,    // Vector base + 0x8A   Reserved
  Unimplemented_ISR,    // Vector base + 0x8C   PWM emergency shutdown
  Unimplemented_ISR,    // Vector base + 0x8E   Port P Interrupt
  Unimplemented_ISR,    // Vector base + 0x90   Reserved
  Unimplemented_ISR,    // Vector base + 0x92   Reserved
  Unimplemented_ISR,    // Vector base + 0x94   Reserved
  Unimplemented_ISR,    // Vector base + 0x96   Reserved
  Unimplemented_ISR,    // Vector base + 0x98   Reserved
  Unimplemented_ISR,    // Vector base + 0x9A   Reserved
  Unimplemented_ISR,    // Vector base + 0x9C   Reserved
  Unimplemented_ISR,    // Vector base + 0x9E   Reserved
  Unimplemented_ISR,    // Vector base + 0xA0   Reserved
  Unimplemented_ISR,    // Vector base + 0xA2   Reserved
  Unimplemented_ISR,    // Vector base + 0xA4   Reserved
  Unimplemented_ISR,    // Vector base + 0xA6   Reserved
  Unimplemented_ISR,    // Vector base + 0xA8   Reserved
  Unimplemented_ISR,    // Vector base + 0xAA   Reserved
  Unimplemented_ISR,    // Vector base + 0xAC   Reserved
  Unimplemented_ISR,    // Vector base + 0xAE   Reserved
  Unimplemented_ISR,    // Vector base + 0xB0   CAN0 transmit
  Unimplemented_ISR,    // Vector base + 0xB2   CAN0 receive
  Unimplemented_ISR,    // Vector base + 0xB4   CAN0 errors
  Unimplemented_ISR,    // Vector base + 0xB6   CAN0 wake-up
  Unimplemented_ISR,    // Vector base + 0xB8   FLASH
  Unimplemented_ISR,    // Vector base + 0xBA   FLASH Fault Detect
  Unimplemented_ISR,    // Vector base + 0xBC   Reserved
  Unimplemented_ISR,    // Vector base + 0xBE   Reserved
  Unimplemented_ISR,    // Vector base + 0xC0   Reserved
  Unimplemented_ISR,    // Vector base + 0xC2   Reserved
  Unimplemented_ISR,    // Vector base + 0xC4   CRG self-clock mode
  Unimplemented_ISR,    // Vector base + 0xC6   CRG PLL lock
  Unimplemented_ISR,    // Vector base + 0xC8   Reserved
  Unimplemented_ISR,    // Vector base + 0xCA   Reserved
  Unimplemented_ISR,    // Vector base + 0xCC   Port H
  Unimplemented_ISR,    // Vector base + 0xCE   Port J
  Unimplemented_ISR,    // Vector base + 0xD0   Reserved
  Unimplemented_ISR,    // Vector base + 0xD2   ATD0
  Unimplemented_ISR,    // Vector base + 0xD4   SCI1
  Unimplemented_ISR,    // Vector base + 0xD6   SCI0     
  Unimplemented_ISR,    // Vector base + 0xD8   SPI0     
  Unimplemented_ISR,    // Vector base + 0xDA   TIM Pulse accumulator input edge      
  Unimplemented_ISR,    // Vector base + 0xDC   TIM Pulse accumulator A overflow      
  Unimplemented_ISR,    // Vector base + 0xDE   TIM timer overflow      
  Unimplemented_ISR,    // Vector base + 0xE0   TIM timer channel 7      
  Unimplemented_ISR,    // Vector base + 0xE2   TIM timer channel 6      
  Unimplemented_ISR,    // Vector base + 0xE4   TIM timer channel 5      
  Unimplemented_ISR,    // Vector base + 0xE6   TIM timer channel 4      
  Unimplemented_ISR,    // Vector base + 0xE8   TIM timer channel 3      
  Unimplemented_ISR,    // Vector base + 0xEA   TIM timer channel 2      
  Unimplemented_ISR,    // Vector base + 0xEC   TIM timer channel 1      
  Unimplemented_ISR,    // Vector base + 0xEE   TIM timer channel 0      
  Unimplemented_ISR,    // Vector base + 0xF0   Real time interrupt
  Unimplemented_ISR,    // Vector base + 0xF2   IRQ      
  Unimplemented_ISR,    // Vector base + 0xF4   XIRQ      
  Unimplemented_ISR,    // Vector base + 0xF6   SWI      
  Unimplemented_ISR     // Vector base + 0xF8   Unimplemented instruction trap      
};
  

//==============================================================================
// PIT_Init
//==============================================================================
void PIT_Init(void)
{      
  PITCE = 0x01;       //enable PIT channel 0
  PITMUX = 0x00;      //all channels counts with micro time base 0
  PITINTE = 0x01;     //channel 0 interrupt enable
    
  //fbus 8MHz
  //period = (PITMTLD+1)*(PITLD+1)/fbus
  //period = (19999+1)*(199+1)/8MHz = 500ms
  PITMTLD0 = 199;     //8bit micro timer load register 0 (micro time base 0)
  PITLD0 = 19999;     //16bit load register channel 0
                
  PITCFLMT = 0x80;    //PIT module enable
}

//==============================================================================
// main
//==============================================================================
void main(void) {
  
  IVBR = 0x7F;  //set vector base
  
  DDRA = 0x01;  //PTA0 as output
  
  PIT_Init();   //init PIT timer. Pin PTA0 will be toggled periodically (0.5s)
  
  EnableInterrupts;

  for(;;) {      
  } //wait forever  
  
}